#ifndef __tkvx433X_HEADER
#define __tkvx433X_HEADER

#if defined(__cplusplus) || defined(__cplusplus__)
extern "C" {
#endif

/*  = tkvx433X/tkvx437X Master/Slave Module Include File ====================  */
/*  = GLOBAL CONSTANT DECLARATIONS ==========================================  */
/*   Replace 10 with the maximum number of devices of this type being used.    */
#define tkvx433X_MAX_INSTR  10
#define NI_VXI  1
#define NI_GPIB 2

/*  = GLOBAL FUNCTION DECLARATIONS ==========================================  */
int tkvx433X_init (int logicalAddress, int selectinterface, int *instrumentID,
                   int masterScannerType);
int tkvx433X_joinmodule (int instrumentID, int moduleNumber, int function);
int tkvx433X_switchrelays (int instrumentID, int moduleNumber, int function,
                           int relayNumber);
int tkvx433X_changedelaytimes (int instrumentID, int function, int moduleNumber,
                               long delaymillisec);
int tkvx433X_set_interrupts (int instrumentID, int type, int interrupt);
int tkvx433X_set_triggers (int instrumentID, int triggerType, int triggerLineNumber);
int tkvx433X_input_program (int instrumentID);
int tkvx433X_end_program (int instrumentID);
int tkvx433X_run_program (int instrumentID, int repetitions);
int tkvx433X_pause_program (int instrumentID);
int tkvx433X_step_program (int instrumentID, int steps);
int tkvx433X_set_timeout (int instrumentID, int timeOutCode);
int tkvx433X_reset (int instrumentID);
int tkvx433X_wait (int instrumentID, int waitTimemillisec);
int tkvx433X_list_error (int instrumentID, char errorMessage[]);
int tkvx433X_close (int instrumentID);

#if defined(__cplusplus) || defined(__cplusplus__)
}
#endif

/*****************************************************************************/
/*=== END INCLUDE FILE ======================================================*/
/*****************************************************************************/

#endif

